/*
 * Copyright (c) 2005 Texas Instruments, Inc.
 *    Ported by SDG Systems, LLC
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation;
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
 *  CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
 *  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
 *  COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
 *  SOFTWARE IS DISCLAIMED.
 *
 */

#ifndef BT_SCRIPT_H
#define BT_SCRIPT_H

#include <inttypes.h>

/*
 * Define the interface of Bluetooth Script
 */

typedef void bts_t;


#define ACTION_SEND_COMMAND             1   /* Send out raw data (as is) */
#define ACTION_WAIT_EVENT               2   /* Wait for data */
#define ACTION_SERIAL_PORT_PARAMETERS   3   
#define ACTION_DELAY                    4   
#define ACTION_RUN_SCRIPT               5   
#define ACTION_REMARKS                  6

/*
 * Structure for ACTION_SEND_COMMAND
 */
typedef struct
{
    unsigned char data[1]; /* Data to send */
} action_command_t;

/*
 * Structure for ACTION_WAIT_EVENT
 */
typedef struct
{
    unsigned int msec; /* in milliseconds */
    unsigned int size;
    unsigned char data[1]; /* Data to wait for */
} action_wait_t;


/*
 * Structure for ACTION_SERIAL_PORT_PARAMETERS
 */
typedef struct
{
    unsigned int baud;
    unsigned int flow_control;
} action_serial_t;

/* Flow Control Type */
#define FCT_NONE        0
#define FCT_HARDWARE    1

#define DONT_CHANGE     0xFFFFFFFF  /* For both baud rate and flow control */


/*
 * Structure for ACTION_DELAY
 */
typedef struct
{
    unsigned int msec; /* in milliseconds */
} action_delay_t;

/*
 * Structure for ACTION_RUN_SCRIPT
 */
typedef struct
{
    char filename[1];
} action_run_t;

/*
 * Structure for ACTION_REMARKS
 */
typedef struct
{
    char m_szRemarks[1];
} action_remarks_t;


const char *cis_create_filename(const unsigned char* cmdparms);
bts_t * bts_load_script(const char* fname, unsigned int* version);
unsigned int bts_next_action(const bts_t* bts_fp, unsigned char* action_buf,
	unsigned int nMaxSize, unsigned short* ptype);
void bts_unload_script(bts_t* bts_fp);

#endif /* BT_SCRIPT_H */


