#include <part.h>
#include <malloc.h>
#include <string.h>

inline static int is_extended(partition_t *p){
	return (p->sys_ind == DOS_EXTENDED_PARTITION ||
                p->sys_ind == WIN98_EXTENDED_PARTITION ||
                p->sys_ind == LINUX_EXTENDED_PARTITION);
}

/*
 * Walk throw the partitions and build
 * hard disk list.
 */
harddisk_t *msdos_get_hdisks(block_dev_desc_t *dev, 
		       	     uint32_t id,
		       	     uint32_t start, 
		       	     harddisk_t *hdisk){

	uint32_t ret	 = 0;
	uint32_t sector  = start;
	uint32_t blksize = dev->blksz;
	uint8_t  *blk	 = (uint8_t *) malloc(blksize);
	mbr_t	 *mbr	 = NULL;
	harddisk_t *last = hdisk;

	// Read block from
	ret = dev->bread(0, sector, 1, (unsigned long *) blk);

	if(ret){
		printf("Failed to read boot sector\n");
		free(blk);
		return NULL;
	}

	mbr = (mbr_t *) blk;

	if(mbr->_magic1 != 0x55 || mbr->_magic2 != 0xAA){
		printf("Invalid MBR magic %02X-%02X\n",
		       mbr->_magic1, mbr->_magic2);
		free(blk);
		return NULL;
	}
	
	harddisk_t  *hd = NULL;
	partition_t *p  = &mbr->partitions[0];
	int	    idx = 0;
		
	for(idx = 0; idx < MAX_NO_OF_PART; ++idx){
		if(is_extended(p)){
			hd = msdos_get_hdisks(dev, id + idx , 
					     sector + p->start_sect,
					     last);

			if(hd != NULL) {	
				last = hd;
			}
			++p;
			continue;
		}

		if(!p->sys_ind){
			continue;
		}
		
		harddisk_t *hd = (harddisk_t *) malloc(sizeof(harddisk_t));
		
		hd->start   = (sector + p->start_sect);
		hd->size    = p->nr_sects;
		hd->id 	    = id + idx;
		hd->sys_ind = p->sys_ind;
		hd->_next   = last;
	
#if defined(HAVE_FS_DEBUG)
		printf("Found partition\n");
		printf("Start : %d\n", hd->start);
		printf("Size  : %d\n", hd->size);
		printf("ID    : %d\n", hd->id);
		printf("Type  : %d\n", hd->sys_ind);
#endif

		last 	   = hd;

		++p;
	}

	free(blk);

	return last;
}
