#ifndef _INTERRUPTS_T
#define _INTERRUPTS_T

#include <bootstrap.h>
#include <mmc/mmc.h>
#include <dma.h>

typedef struct _interrupt_level_t {
	uint32_t itr;
	uint32_t mir;
	uint32_t _pad0;
	uint32_t _pad1;
	uint32_t sir_irq_code;
	uint32_t sir_fiq_code;
	uint32_t cntl;
	uint32_t ilr[32];
} interrupt_level_t;

/* This should be used by FIQ/IRQ
 * handlers.
 */
extern interrupt_level_t *level1;
extern interrupt_level_t *level2;

/*
 * Interrupt interface.
 */
extern void irq_dispatch(uint32_t);
extern void irq_mask(uint32_t);
extern void irq_unmask(uint32_t);
extern void irq_maskall();

/*
 * OMAP interrupts
 */
#define DMA_CHANNEL0_IRQ	19
#define MMC_IRQ			55

#endif
