#ifndef _MALLOC_H
#define _MALLOC_H

#include <xtype.h>

// Align block size
#define ALIGN(bsize, boundry) ((bsize + boundry - 1) & ~(boundry - 1))

// Page size 4K
#define PAGE_SIZE	0x1000

// block size
#define BSIZE		sizeof(uint32_t)

// Minimum allowed allocate block
#define SMALLBLOCK	(BSIZE + sizeof(block_t))

// block header size
#define BLOCKSIZE	sizeof(block_t) 

// Calculate block pointer using
// a given offset and base
#define BLOCK(base, offset)	(block_t *) ((uint8_t *) base + (offset))

// Memory block
typedef struct __block_t {
	struct __block_t *next;		/* Next block in the list */
	size_t	   	 size;		/* size of the block */
} block_t;

#define DEBUG_MALLOC 1
#if defined(DEBUG_MALLOC)
extern void __debug_malloc();
#endif

extern void *malloc(size_t);
extern void free(void *);
extern void setup_heap(size_t size);
extern void __debug_malloc();

#endif
