#include <interrupts.h>

interrupt_level_t *level1 = (interrupt_level_t *) IH1_BASE;
interrupt_level_t *level2 = (interrupt_level_t *) IH2_BASE;

void do_irq(regs_t *regs){
	uint32_t level1_irq = level1->sir_irq_code;
	uint32_t level2_irq = level2->sir_irq_code;
	uint32_t irq	    = level1_irq;

	/* Mask interrupt and ACK */
	level1->mir  |= (1 << level1_irq);
	level1->cntl  = 0x01;

	switch(level1_irq){
	case 0: /* IRQ0 Level 2 */
		level2->mir  |= (1 << level2_irq);
		level2->cntl  = 0x01;
		irq	      = level2_irq + 32;

		irq_dispatch(irq);
	
		/* unmask interrupt */
		level2->mir &= ~(1 << level2_irq);
		break;
	case 19: // DMA Channel 0/6
		irq_dispatch(irq);
		break;
	default:
		printf("IRQ%02d not supported\n", level1_irq);
		break;
	}

	/* unmask interrupt now */
	level1->mir &= ~(1 << level1_irq);
}

void do_fiq(regs_t *regs){
	printf("FIQ\n");
}

void do_bad_trap(regs_t *regs){
	printf("R0   = %08X R1  = %08X\n"
	       "R2   = %08X R3  = %08X\n"
	       "R4   = %08X R5  = %08X\n"
	       "R6   = %08X R7  = %08X\n"
               "R8   = %08X R9  = %08X\n"
	       "R10  = %08X R11 = %08X\n"
               "R12  = %08X LR  = %08X\n"
	       "CPSR = %08X\n",
	  	regs->r0,regs->r1,regs->r2, regs->r3,regs->r4,
		regs->r5,regs->r6, regs->r7,regs->r8,regs->r9,
		regs->r10,regs->r11,regs->r12,regs->lr,regs->cpsr);
	while(1);
}

void do_swi(regs_t *regs){
	printf("SWI\n");
	printf("R0   = %08X R1  = %08X\n"
               "R2   = %08X R3  = %08X\n"
               "R4   = %08X R5  = %08X\n"
               "R6   = %08X R7  = %08X\n"
               "R8   = %08X R9  = %08X\n"
               "R10  = %08X R11 = %08X\n"
               "R12  = %08X LR  = %08X\n"
               "CPSR = %08X\n",
                regs->r0,regs->r1,regs->r2, regs->r3,regs->r4,
                regs->r5,regs->r6, regs->r7,regs->r8,regs->r9,
                regs->r10,regs->r11,regs->r12,regs->lr,regs->cpsr);
}

void do_hw_interrupts(){
	uint32_t *itr	= NULL;
	uint32_t *mir	= NULL;
	uint32_t *ctl	= NULL;	


	/*
         * Clear and nask interrupt level 1
         */
	itr = (uint32_t *) (IH1_BASE + IRQ_ITR);
	mir = (uint32_t *) (IH1_BASE + IRQ_MIR);
	ctl = (uint32_t *) (IH1_BASE + IRQ_CONTROL_REG);

	*mir = 0xffffffff;
	*itr = 0;
	*ctl = 0x03;

	/*
	 * Clear and mask interrupt level 2
	 */
	itr = (uint32_t *) (IH2_BASE + IRQ_ITR);
        mir = (uint32_t *) (IH2_BASE + IRQ_MIR);
        ctl = (uint32_t *) (IH2_BASE + IRQ_CONTROL_REG);

        *mir = 0xffffffff;
	*itr = 0;
	*ctl = 0x03;
}
