#include <interrupts.h>


/*
 * Call driver irq handler
 */
void irq_dispatch(uint32_t irq) {
	switch(irq){
	case MMC_IRQ: // MMC drivers
		omap_mmc_irq();
		break;
	case DMA_CHANNEL0_IRQ:
		omap_dma_irq(0);
		break;
	default:
		printf("Unknown IRQ%02d\n",irq);
		break;
	}
}

/*
 * Mask IRQ
 */
void irq_mask(uint32_t irq){
	uint32_t level1_irq = irq;
	uint32_t level2_irq = 0;

	if(irq > 31){
		/* Level 2 interrupt */
		level2_irq   = irq - 32;
		level1_irq   = 0;
		level2->mir |= (1 << level2_irq);
	}

	level1->mir |= (1 << level1_irq);
}

/*
 * Unmask IRQ
 */
void irq_unmask(uint32_t irq){
        uint32_t level1_irq = irq;
        uint32_t level2_irq = 0;

        if(irq > 31){
                /* Level 2 interrupt */
                level2_irq   = irq - 32;
		level1_irq   = 0;
                level2->mir &= ~(1 << level2_irq);
        }

        level1->mir &= ~(1 << level1_irq);
}

void irq_maskall(){
	level1->mir  = 0xFFFFFFFF;
	level1->itr  = 0;
	level1->cntl = 0x03;	

	level2->mir  = 0xFFFFFFFF;
	level2->itr  = 0;
	level2->cntl = 0x03;
}
