#include "fat_fs.h"


static inline char *get_end(char *str) {
	char   *p   = str;

	if(!p || *p == '\0'){
		// We are at the end of
		// the string.
		return NULL;
	}

	// Look for the next seprater
	while(*p != '/' && *p != '\0') ++p;

	return p;
}
	

inode_t *fat_lookup(char *path, supper_block_t *data){
        fat_sb_t    *sb   = (fat_sb_t *) data;
	char	    *p	  = NULL;	
	char	    *n	  = path; 
	char	     c	  = 0;
	inode_t	    *node = (inode_t *) malloc(sizeof(inode_t));
	
	if(!path){
		free(node);
		return NULL;
	}

	memset((void *) node, 0, sizeof(inode_t));
	node->blk = (uint8_t *) malloc(sb->cluster_size * sb->sector_size);
	
	do {
		if(!(p = get_end(n))){
			// We are the end of the
			// file path
			break;
		}

		// Mark the end
		 c = *p;
		*p = '\0';

		// Now lookup the entry in the directory.
		if(fat_lookup_node(sb, n, node) == -1){
			free(node->blk);
			free(node);
		
			return NULL;
		}

		// Restore and move to
		// next entry.
		*p = c;
		n  = p + 1;
	}while(*p != '\0');

	return node;
}
