#ifndef	_MMC_H
#define	_MMC_H

#include <common.h>
#include <omap1510.h>
#include <mmc/protocol.h>

#define MAX_MMC_BLOCK_SIZE	512

#define _mmc_cmdtype(c)	(c << 12)

/*
 * Command types
 */
#define MMC_CMDTYPE_BC     _mmc_cmdtype(0)
#define MMC_CMDTYPE_BCR    _mmc_cmdtype(1)
#define MMC_CMDTYPE_AC     _mmc_cmdtype(2)
#define MMC_CMDTYPE_ADTC   _mmc_cmdtype(3)

#define _mmc_resptype(r)	(r << 8)

/*
 * Response types
 */
#define MMC_RESP_NONE	_mmc_resptype(0)
#define MMC_RESP_R1	_mmc_resptype(1)
#define MMC_RESP_R2	_mmc_resptype(2)
#define MMC_RESP_R3	_mmc_resptype(3)
#define MMC_RESP_R4	_mmc_resptype(4)
#define MMC_RESP_R5	_mmc_resptype(5)
#define MMC_RESP_R6	_mmc_resptype(6)

#define MMC_WRITEDIR	0
#define MMC_READDIR	(1 << 15)

#define MMC_DEFAULT_RCA	1

#define MMC_ERR_NONE    0
#define MMC_ERR_TIMEOUT 1
#define MMC_ERR_BADCRC  2
#define MMC_ERR_FIFO    3
#define MMC_ERR_FAILED  4
#define MMC_ERR_INVALID 5


typedef struct {
        unsigned int            manfid;
        char                    prod_name[8];
        unsigned int            serial;
        unsigned short          oemid;
        unsigned short          year;
        unsigned char           hwrev;
        unsigned char           fwrev;
        unsigned char           month;
}mmc_cid_t;

typedef struct {
        unsigned char           mmca_vsn;
        unsigned short          cmdclass;
        unsigned short          tacc_clks;
        unsigned int            tacc_ns;
        unsigned int            max_dtr;
        unsigned int            read_blkbits;
        unsigned int            capacity;
} mmc_csd_t;

extern void 		omap_mmc_irq();
extern block_dev_desc_t *omap_mmc_init();

#endif
