/*
 * (C) Copyright 2000-2004
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#ifndef _PART_H
#define _PART_H

#include <xtype.h>

typedef unsigned long lbaint_t;

typedef struct block_dev_desc {
	int		if_type;	/* type of the interface */
	int	        dev;	  	/* device number */
	unsigned char	part_type;  	/* partition type */
	unsigned char	target;		/* target SCSI ID */
	unsigned char	lun;		/* target LUN */
	unsigned char	type;		/* device type */
	unsigned char	removable;	/* removable device */
	lbaint_t	lba;	  	/* number of blocks */
	unsigned long	blksz;		/* block size */
	unsigned char	vendor [40+1]; 	/* IDE model, SCSI Vendor */
	unsigned char	product[20+1];	/* IDE Serial no, SCSI product */
	unsigned char	revision[8+1];	/* firmware revision */
	unsigned long	(*bread)(int dev,
				 unsigned long start,
				 lbaint_t blkcnt,
				 unsigned long *buffer);
}block_dev_desc_t;

/* Interface types: */
#define IF_TYPE_MMC		6

/* Part types */
#define PART_TYPE_UNKNOWN	0x00
#define PART_TYPE_MAC		0x01
#define PART_TYPE_DOS		0x02
#define PART_TYPE_ISO		0x03
#define PART_TYPE_AMIGA		0x04

/* device types */
#define DEV_TYPE_HARDDISK	0x00	/* harddisk */

enum {
        DOS_EXTENDED_PARTITION 	 = 5,
        LINUX_EXTENDED_PARTITION = 0x85,
        WIN98_EXTENDED_PARTITION = 0x0f,

        LINUX_SWAP_PARTITION = 0x82,
        LINUX_RAID_PARTITION = 0xfd,    /* autodetect RAID partition */

        SOLARIS_X86_PARTITION 	  = LINUX_SWAP_PARTITION,
        NEW_SOLARIS_X86_PARTITION = 0xbf,

        DM6_AUX1PARTITION = 0x51,       /* no DDO:  use xlated geom */
        DM6_AUX3PARTITION = 0x53,       /* no DDO:  use xlated geom */
        DM6_PARTITION = 0x54,           /* has DDO: use xlated geom & offset */
        EZD_PARTITION = 0x55,           /* EZ-DRIVE */

        FREEBSD_PARTITION = 0xa5,       /* FreeBSD Partition ID */
        OPENBSD_PARTITION = 0xa6,       /* OpenBSD Partition ID */
        NETBSD_PARTITION = 0xa9,        /* NetBSD Partition ID */
        BSDI_PARTITION = 0xb7,          /* BSDI Partition ID */
        MINIX_PARTITION = 0x81,         /* Minix Partition ID */
        UNIXWARE_PARTITION = 0x63,      /* Same as GNU_HURD and SCO Unix */
};



typedef struct _partition_t {
        unsigned char boot_ind;         /* 0x80 - active */
        unsigned char head;             /* starting head */
        unsigned char sector;           /* starting sector */
        unsigned char cyl;              /* starting cylinder */
        unsigned char sys_ind;          /* What partition type */
        unsigned char end_head;         /* end head */
        unsigned char end_sector;       /* end sector */
        unsigned char end_cyl;          /* end cylinder */
        unsigned int start_sect;        /* starting sector counting from 0 */
        unsigned int nr_sects;          /* nr of sectors in partition */
} __attribute__((packed)) partition_t;

#define MAX_NO_OF_PART	4

typedef struct _mbr_t {
	uint8_t 	_pad[446];
	partition_t	partitions[MAX_NO_OF_PART];
	uint8_t		_magic1;
	uint8_t		_magic2;
} __attribute__ ((packed)) mbr_t;

typedef struct _harddisk_t {
	uint32_t start;		// First block
	uint32_t size;		// total size;
	uint32_t id;		// Uniqe ID
	uint32_t sys_ind;

	/* Build list of hard disks */
	struct _harddisk_t *_next;
} harddisk_t;


extern harddisk_t *harddisks;

extern harddisk_t *msdos_get_hdisks(block_dev_desc_t *dev,
                             	    uint32_t id,
                             	    uint32_t start,
                             	    harddisk_t *hdisk);

#endif /* _PART_H */
