#include <config.h>
#include <omap1510.h>

#define S_FRAME_SIZE    56

#define MODE_SYS	0x1F
#define MODE_UNDEF	0x1B
#define MODE_ABT	0x17
#define MODE_SVC 	0x13
#define MODE_IRQ	0x12
#define MODE_FIQ	0x11
#define MODE_USER	0x10
#define I_BIT    	0x80
#define F_BIT		0x40
#define IF_BITS		0xC0

	.macro enable,r,intr
        mrs     \r, cpsr
        bic     \r,\r, \intr
        msr     cpsr, \r
        .endm
	
	.macro switch_mode,r,mode
	mov	\r, \mode
	msr	cpsr, \r
	.endm

	.macro save_regs, jump
	sub	lr, lr, \jump
        stmfd   sp!, {r0-r12,lr}
	mrs     r0, cpsr
	stmfd	sp!, {r0}
	sub	r0, sp, #S_FRAME_SIZE
	.endm

	.macro restore_regs
	ldmfd	sp!, {r0}	 // read CPRS
	ldmfd   sp!, {r0-r12,pc}^ // Read the rest of registers
	.endm

	.align 4
_reset_stub:
1:	nop
	b 1b


	.align 4
_irq_stub:
	save_regs #4
	bl 	do_irq
	restore_regs

	.align 4
_fiq_stub:
        save_regs #4
        bl 	do_fiq
        restore_regs
	
	.align 4
_swi_stub:
	stmfd	sp!, {r0-r12,lr}
	mrs     r0, cpsr
	stmfd	sp!, {r0}	
	sub     r0, sp, #S_FRAME_SIZE
	bl	do_swi
	ldmfd	sp!, {r0}
	ldmfd	sp!, {r0-r12,pc}^

	.align 4
_bad_stub:
	save_regs #8
        bl      do_bad_trap

	.globl _vector
	.align	4
_vector:
	ldr	pc, _stubs
	ldr	pc, _stubs + 4
	ldr	pc, _stubs + 8
	ldr	pc, _stubs + 12
	ldr	pc, _stubs + 16
	nop
	ldr	pc, _stubs + 24
	ldr	pc, _stubs + 28

        .align 4
        .globl _stubs
_stubs:
        .word   _reset_stub
        .word   _bad_stub
        .word   _swi_stub
        .word   _bad_stub
        .word   _bad_stub
        .word   0x00000000
        .word   _irq_stub
        .word   _fiq_stub

	.globl setup_traps
setup_traps:
	stmfd   sp!, {r4 - r6, lr}

	/* Setup Interrupts stacks FIQ/IRQ/ ... etc */
	switch_mode	r6,#(IF_BITS|MODE_IRQ)
	sub     	r1,  r0, #CONFIG_STACKSIZE_IRQ
	mov		r13, r1
	switch_mode	r6,#(IF_BITS|MODE_FIQ)
	sub     	r1,  r1, #CONFIG_STACKSIZE_FIQ
	mov		r13, r1
	switch_mode	r6,#(IF_BITS|MODE_ABT)
	sub     	r1,  r1, #CONFIG_STACKSIZE_BAD
	mov		r13, r1
	switch_mode	r6,#(IF_BITS|MODE_UNDEF)
	mov		r13, r1
	switch_mode	r6,#(IF_BITS|MODE_SVC)

	/* Adjust addresses in
	 * the stubs table
	 */
	mov	r0, #0x13000000
	orr	r0,r0,#0x00F00000
	adr	r1, _stubs
	add	r2, r1, #32
1:	ldr	r3, [r1]
	add	r3,r3,r0
	str	r3, [r1], #4
	teq	r1, r2
	bne	1b

	/* Relocate the vector
	 * to 0xFFFF0000.
	 */
	mov	r0, #0xFF000000
	orr	r0,r0,#0x00FF0000
	adr	r1, _vector
	add	r2, r1, #32
2:	ldr	r3, [r1], #4
	str	r3, [r0], #4
	teq	r1, r2
	bne	2b

	/* Now copy the stubs
	 * table as will.
	 */
	mov	r0, #0xFF000000
	orr	r0, r0, #0x00FF0000
	add	r0, r0, #32
	adr	r1, _stubs
	add	r2, r1, #32
3:	ldr	r3, [r1], #4
	str	r3, [r0], #4
	teq	r1,r2
	bne	3b

	bl 	do_hw_interrupts

	/* Enable IRQ/FIQ */
	enable r0,#I_BIT
	enable r0,#F_BIT

	ldmfd	sp!, {r4 - r6, lr}
	
	mov	pc, lr
