#include <config.h>
#include <asm/system.h>
#include <asm/domain.h>
#include <asm/pgtable.h>

.extern create_regions


	.macro cls,base,color
	mov     r6, \color
        mov     r7, \base
        orr     r7, r7, #0x00000120
        orr     r7, r7, #0x00004000
        add     r8, r7, #153600
1:	str     r6, [r7], #4
        teq     r7,r8
        bne	1b
	.endm


.globl _start
_start:
	/* Save input parameters
	 * from wince loader
	 */
	str	r7, bootstrap_info + 20 	// Parameters
	str	r1, bootstrap_info + 24		// Machine Type
	str	r2, bootstrap_info + 28		// Tags address
	str	r3, bootstrap_info + 32		// Kernel address
	
	mov     r0, #0xff000000
        orr     r0,r0,#0x00ff0000
        orr     r0,r0,#0x0000f000
        and     r0,r0,pc

	ldr	r1, _bootstrap_begin
	ldr	r2, _bootstrap_size
	sub	r2, r2, r1

	/* The end of the source 
	 * location.
	 */
	add	r3, r1, r0
	add	r3, r3, r2
	sub	r3, r3, #4

	/* The end of the destination
	 * location.
	 */
	mov	r4, #0x13000000
	orr	r4, r4, #0x00F00000
	add	r4, r4, r1
	add	r4, r4, r2
	sub	r4, r4, #4

	/*
	 * Copy the reset of the 
	 * image, except for the 
	 * startup code.
	 */
1:	ldr	r5, [r3]
	str	r5, [r4]
	sub	r3, r3, #4
	sub	r4, r4, #4
	sub	r2, r2, #4
	teq	r2, #0
	bne	1b

	/* Now lets jump to the
	 * new location
	 */
	ldr	r3, _bootstrap_begin
	mov     r2, #0x13000000
        orr     r2, r2, #0x00F00000
        add     pc, r2, r3

.globl _init
_init:
	/* Before we do anthing
         * We need to adjust all
         * globl pointers and refernces
         * 1. Calculate the base address
         *    using PC register
         * 2. Calclutate the base address
         *    for GOT section
         * 3. Walk throw the entries and
         *    adjust the address
         */
	mov     r1, #0x13000000
        orr     r1, r1, #0x00F00000
        ldr     r2,reloctbl_start
        add     r10,r1,r2
        mov     r3, r10

1:      ldr     r4, [r3]
        cmp     r4, #0
        beq     ok
        add     r4,r4,r1        /* Add the base address to the offset */
        str     r4,[r3], #4     /* Store the new address */
        b       1b

ok:
	/* Now lets calculate the
	 * physical address, which
	 * is going to be used after
	 * we disable MMU and start linux
	 */
	adr	r4, _boot
	str	r4, bootstrap_info

	/*
         * Lets setup the stack,
	 * We will need to ajust
	 * the value after we enable
	 * MMU
         */
        sub     sp, r1, #CONFIG_STACK_SIZE

        /* Clean the stack */
        mov     r4, #0
        mov     r3, sp
        add     r5, r3, #CONFIG_STACK_SIZE
4:      str     r4, [r3],#4
        cmp     r5,r3
        bne     4b

	/* Clear bss section */
        mov     r4, #0
        ldr     r5,bss_start            // Get bss start offset
        add     r5,r5, r1               // Calculate start address
        ldr     r6,bss_end              // Get bss end offset
        add     r6, r6, r1              // Calculate end address
5:      str     r4, [r5], #4
        cmp     r5,r6
        bne     5b


	bl	win_cleanup	// Clean and configure video
	bl      __create_table  // Create MMU L1 table

        /* Save virtual address we need
         * Jump to when after enabling MMU
         */
	adr	r13, __mmu_mapped

        b	__enable_mmu


.globl	__mmu_mapped
__mmu_mapped:
	mov     r1, #0x13000000
        orr     r1, r1, #0x00F00000
	
done:
	/*
	 * Lets setup the stack
	 */
	sub	sp, r1, #CONFIG_STACK_SIZE

	/* Clean the stack */
	mov	r4, #0
	sub	r3, sp, #(CONFIG_STACKSIZE_FIQ + CONFIG_STACKSIZE_IRQ)
	add	r5, r3, #(CONFIG_STACK_SIZE + CONFIG_STACKSIZE_FIQ + CONFIG_STACKSIZE_IRQ)
	add	r5, r3, #(CONFIG_STACKSIZE_BAD)
4:	str	r4, [r3],#4
	cmp	r5,r3
	bne	4b

	/* Use user stack pointer to
	 * calculate IRQ/FIQ stack pointer
	 */
	mov	r0, sp

	/* Copy interrupts vector to
	 * rigth location.
	 */
	bl	setup_traps	

	/* Calculate the virtual
	 * address for MMU L1 table
	 */
	mov     r0, #0x13000000
        orr     r0, r0, #0x00E00000

	str     r0, bootstrap_info + 8

	/*
	 * Jump to startup	
	 * function.
	 */
	bl	bootstrap_main


/*
 * bss_start and bss_end 
 * will contain the offset
 * of begning and end of .bss
 * section so we can clear it
 */
.globl bss_start
bss_start: .word __bss_start

.globl _bss_end
bss_end: .word __bss_end

/* Size of bootstrap code */
.globl _bootstrap_size 
_bootstrap_size: .word __bootstrap_size

.globl _bootstrap_begin
_bootstrap_begin : .word _init

/*
 * reloctbl_start is the offset for
 * Globle location table the startup
 * code will have to adjust the entry
 * address for this table
 */
.globl reloctbl_start
reloctbl_start: .word __reloctbl_start

.globl reloctbl_end
reloctbl_end: .word __reloctbl_end

	.globl 	bootlinux
	.type	bootlinux, %function
bootlinux:

	/* Setup boot parameters first
	 * r0 	allows 0
	 * r1	Machine Type
	 * r2	Tags list address
	 * r3	Kernel Image address
	 */
	mov	r0, #0
	ldr	r1, bootstrap_info + 24
	ldr	r2, bootstrap_info + 28
	ldr	r3, bootstrap_info + 32

	/* 1. Disable all type of interrupts
         * 2. Disable MMU and jump to physical location
         * 3. Now you can jump to linux image.
         */
        mrs     r4, cpsr
        orr     r4,r4, #0xC0
        msr     cpsr, r4

	mcr   	p15, 0, r6, c7, c5, 0   @ invalidate I cache
       	mcr   	p15, 0, r6, c7, c10, 4  @ drain WB
       	mcr   	p15, 0, r6, c8, c7, 0   @ invalidate I-D TLB

        b 	__disable_mmu

/* This function going to create
 * MMU L1 table, and map the the
 * required table.
 */
	.type	__create_table, %function
__create_table:
	/* Save previous state */
	stmdb   sp!, {lr}

	/* Load MMU L1 address */
	ldr	r4, bootstrap_info + 8

	/* Call C-functions to do the
	 * the actule mapping.
	 */
	bl create_regions

	/* Restore last state */
	ldmia sp!,{pc}

/*
 * This function preper co-processer before
 * enable enabling MMU, I toke this code
 * from linux kernel
 */
	.type __enable_mmu, %function
__enable_mmu:
	/* Reset process ID */
	mov	r2, #0

	/* Get MMU L1 base address */
	ldr     r4, bootstrap_info + 8

	/* Disable everything expect
	 * for MMU.
	 */
	mrc     p15, 0, r0, c1, c0, 0
        orr     r0, r0, #CR_A
        bic     r0, r0, #CR_C
        bic     r0, r0, #CR_Z
        bic     r0, r0, #CR_I
	orr	r0, r0, #CR_V
        orr     r0, r0, #CR_M      	/* bit 0 of c1 is MMU enable*/

	/* configure Domain register */
        mov     r5, #(domain_val(DOMAIN_USER, DOMAIN_MANAGER) | \
                      domain_val(DOMAIN_KERNEL, DOMAIN_MANAGER) | \
                      domain_val(DOMAIN_TABLE, DOMAIN_MANAGER) | \
                      domain_val(DOMAIN_IO, DOMAIN_CLIENT))
        mcr     p15, 0, r5, c3, c0, 0           @ load domain access register
        mcr     p15, 0, r4, c2, c0, 0           @ load page table pointer
	mcr	p15, 0, r2, c13,c0, 0		@ Reset context ID

        b       __turn_mmu_on

/*
 * Lets enable MMU
 */
        .type   __turn_mmu_on, %function
__turn_mmu_on:
	nop
        nop
        mcr     p15, 0, r0, c1, c0, 0           @ write control reg
        mov     pc, r13
	nop
	nop
	nop

	.type	__disable_mmu, %function
__disable_mmu:
	ldr     r4, bootstrap_info

	/*
	 * Disable MMU so we can start linux
         */
        mrc     p15, 0, ip, c1, c0, 0
	bic	ip, ip, #CR_B
	bic	ip, ip, #CR_V
	bic	ip, ip, #CR_R
	bic	ip, ip, #CR_S
	bic	ip, ip, #CR_W
	bic 	ip, ip, #CR_M

	b	__turn_mmu_off

	.type	__turn_mmu_off, %function
__turn_mmu_off:
	nop
	nop
	nop
	mcr	p15, 0, ip, c1, c0, 0    @ write control reg
	mov	pc, r4
	nop
_boot:	nop
	nop
	nop
	nop
	mov	pc, r3			@ We can now start linux

/*
 * Information required by
 * the bootstrap.
 * 1. Physical address will be used to switch off MMU
 * 2. Virtual address to jump to when MMU is enabled
 * 2. bootstrap data section physocal address
 * 3. MMU L1 section flags
 * 4. Address to jump to after we relocate
 * 5. Address for data section which contains
 *    TLB and stack 
 * 6. Address of the bootstrap parameters
 * 7. Machine type
 * 8. Address of linux kernel tags
 * 9. Address of linux kernel image
 * 10. Malloc minimum allowed address
 * 11. Malloc start address
 */
	.globl	bootstrap_info
	.type	bootstrap_info,#object
bootstrap_info:
	.long	_boot
	.long	__mmu_mapped
	.long	CONFIG_BOOTSTRAP_DATA_BASE
	.long 0x00000000
	.long CONFIG_BOOTSTRAP_DATA_START
	.long 0x00000000
	.long 0x00000000
	.long 0x00000000
	.long 0x00000000
	.long 0x00000000
	.long 0x00000000
