#ifndef _LOADIN_H
#define _LOADIN_H

#include <windows.h>
#include <stdio.h>
#include "setup.h"

#define LOCKFLAG_WRITE		0x001 // write access required
#define LOCKFLAG_QUERY_ONLY 0x002 // query only, page in but don't lock
#define LOCKFLAG_READ		0x004 // read access required (as opposed to page present but PAGE_NOACCESS)

#define PAGE_SIZE	0x10000	// 64K size

typedef struct _image_t {
	unsigned long src;
	unsigned long dst;
	unsigned long size;
}image_t;

#define MAX_FILENAME_PATH	512
#define MAX_CMDLINE_LEN		512
#define MAX_PAGES			1024
#define GET_DATA(entry)		((u8 *) entry + sizeof(entry_t))
#define ALIGN_ADDR(addr)	{							\
	unsigned long aligned = (addr & 0xFFFFF000);		\
	addr = (addr == aligned)? addr : (aligned + 0x1000);\
}

#define ROUND_64K(size) ((size + PAGE_SIZE - 1) & ~(PAGE_SIZE - 1))
#define ROUND_4B(size) ((size + 3) & ~3)

typedef struct _bootstrap_param_t {
	// tags information
	unsigned long tags_size;
	unsigned long tags_src;
	unsigned long tags_dst;

	// Kernel information
	unsigned long kernel_size;
	unsigned long kernel_src;
	unsigned long kernel_dst;

	// Initrd information
	unsigned long initrd_size;
	unsigned long initrd_src;
	unsigned long initrd_dst;
	
	// Machine type
	int			  type;

	// Second bootstrap address
	// it's optional.
	unsigned long bootstrap;
} bootstrap_param_t;

typedef struct loadin_conf {
	char		  initrd[MAX_FILENAME_PATH];
	char		  image[MAX_FILENAME_PATH];
	char		  bootstrap[MAX_FILENAME_PATH];
	char		  cmdline[MAX_CMDLINE_LEN];
	int			  type;
	unsigned long heapsize;
}loadin_conf_t;

#define PAGE_NOACCESS			0x01            
#define PAGE_READONLY			0x02
#define PAGE_READWRITE			0x04  
#define PAGE_EXECUTE			0x10
#define PAGE_EXECUTE_READ		0x20
#define PAGE_EXECUTE_READWRITE	0x40
#define PAGE_GUARD				0x100          
#define PAGE_NOCACHE			0x200
#define PAGE_PHYSICAL			0x400


extern "C" 
{
	// Mark begining and 
	// end of the bootstrap
	void bootstrap_end();
	void bootstrap_start();


	u32 get_phyaddress(void *addr);
	void *alloc_phys(u32 size, unsigned long *ppa);

	BOOL LockPages(LPVOID lpvAddress, DWORD cbSize, PDWORD pPFNs, int fOptions);
	BOOL VirtualCopy (LPVOID lpvDestMem, LPVOID lpvSrcMem,
					  DWORD dwSizeInBytes, DWORD dwProtectFlag);

	LPVOID AllocPhysMem(DWORD cbSize, DWORD fdwProtect, DWORD dwAlignmentMask, DWORD dwFlags, PULONG pPhysicalAddress);

	//void boot(u32 map, u32 entry, u32 addr);
	void boot(u32 label, u32 params);
	void Jump();
}

#endif
